class MA2_Mutator expands Mutator config(ut4ever);

function PreBeginPlay ()
{

	Super.PreBeginPlay();

	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'MH_DamageMutator'));

	SetTimer(1.0,True);

}

simulated function bool AlwaysKeep(Actor Other)
{

	if ( Other.IsA('Carcass') )
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
	if ( Other.IsA('MonsterEnd') )
		{
		MonsterEnd(Other).bHidden = False;
		}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;
local int X;

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{
		if ( inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('ChainSaw') && !inv.IsA('Translocator') )
			{
			weap = Weapon(inv);

			//spawn inventory item to world:
			dropped = Spawn(weap.Class,,,Killed.Location);

			speed = VSize(Killed.Velocity);

			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);

			weap = Weapon(dropped);

			weap.PickupAmmoCount = weap.default.PickupAmmoCount;

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			}
		Killed.Inventory.Destroy();
		}

	if ( Killed.IsA('PlayerPawn') || Killed.IsA('Bot') )
		{
		Killed.PlayerReplicationInfo.Deaths += 1;
		Killed.PlayerReplicationInfo.Score *= 0.5;
		Killed.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Class'DiedMessage' );
		}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

function Timer()
{
local Pawn P;
local Inventory Inv;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			if (P.Health < 500)
				P.Health++;
			for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
				{ 
				if ( Inv.IsA('Weapon') && !Inv.IsA('WarheadLauncher') )
					{
					if ( Weapon(Inv).Ammotype != none )
						{
						if ( Weapon(Inv).Ammotype.AmmoAmount < Weapon(Inv).PickupAmmoCount * 4 )
							{
							if (Weapon(Inv).IsA('minigun2'))
								{
								Weapon(Inv).Ammotype.AmmoAmount += 5;
								if ( Weapon(Inv).Ammotype.AmmoAmount > Weapon(Inv).PickupAmmoCount * 4 )
									{
									Weapon(Inv).Ammotype.AmmoAmount = Weapon(Inv).PickupAmmoCount * 4;
									}
								}
							else
								{
								Weapon(Inv).Ammotype.AmmoAmount++;
								}
							}
						}
					}
				}
			}
		}

}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;

	// replace Unreal I inventory actors by their Unreal Tournament equivalents
	// set bSuperRelevant to false if want the gameinfo's super.IsRelevant() function called
	// to check on relevancy of this actor.

	bSuperRelevant = 1;
	if ( Other.bIsPawn && Pawn(Other).bIsPlayer )
		{
		Pawn(Other).JumpZ=375.000000;	//325	
		}

	if ( Other.IsA('StationaryPawn') )
		return true;

	Inv = Inventory(Other);
 	if ( Inv == None )
	{
		bSuperRelevant = 0;
		if ( Other.IsA('TorchFlame') )
			Other.NetUpdateFrequency = 0.5;
		return true;
	}

	if ( Other.IsA('Weapon') )
	{
		if ( Other.IsA('TournamentWeapon') )
			return true;

		if ( Other.IsA('Stinger') )
		{
			ReplaceWith(Other, "Botpack.PulseGun");
			return false; 
		}
		if ( Other.IsA('Rifle') )
		{
			ReplaceWith( Other, "Botpack.SniperRifle" );
			return false;
		}
		if ( Other.IsA('Razorjack') )
		{
			ReplaceWith( Other, "Botpack.Ripper" );
			return false;
		}
		if ( Other.IsA('Minigun') )
		{
			ReplaceWith( Other, "Botpack.Minigun2" );
			return false;
		}
		if ( Other.IsA('AutoMag') )
		{
			ReplaceWith( Other, "Botpack.Enforcer" );
			return false;
		}
		if ( Other.IsA('Eightball') )
		{
			ReplaceWith( Other, "Botpack.UT_Eightball" );
			return false;
		}
		if ( Other.IsA('FlakCannon') )
		{
			ReplaceWith( Other, "Botpack.UT_FlakCannon" );
			return false;
		}
		if ( Other.IsA('ASMD') )
		{
			ReplaceWith( Other, "Botpack.ShockRifle" );
			return false;
		}
		if ( Other.IsA('GesBioRifle') )
		{
			ReplaceWith( Other, "Botpack.UT_BioRifle" );
			return false;
		}
		if ( Other.IsA('DispersionPistol') )
		{
			ReplaceWith( Other, "Botpack.ImpactHammer");
			return false;
		}
		bSuperRelevant = 0;
		return true;
	}
	if ( Other.IsA('Ammo') )
	{
		if ( Other.IsA('TournamentAmmo') )
			return true;

		if ( Other.IsA('ASMDAmmo') )
		{
			ReplaceWith( Other, "Botpack.ShockCore" );
			return false;
		}
		if ( Other.IsA('RocketCan') )
		{
			ReplaceWith( Other, "Botpack.RocketPack" );
			return false;
		}
		if ( Other.IsA('StingerAmmo') )
		{
			ReplaceWith(Other, "Botpack.PAmmo");
			return false;
		}
		if ( Other.IsA('RazorAmmo') )
		{
			ReplaceWith( Other, "Botpack.BladeHopper" );
			return false;
		}
		if ( Other.IsA('RifleRound') )
		{
			ReplaceWith( Other, "Botpack.RifleShell" );
			return true;
		}
		if ( Other.IsA('RifleAmmo') )
		{
			ReplaceWith( Other, "Botpack.BulletBox" );
			return false;
		}
		if ( Other.IsA('FlakBox') )
		{
			ReplaceWith( Other, "Botpack.FlakAmmo" );
			return false;
		}
		if ( Other.IsA('Clip') )
		{
			ReplaceWith( Other, "Botpack.EClip" );
			return false;
		}
		if ( Other.IsA('ShellBox') )
		{
			ReplaceWith( Other, "Botpack.MiniAmmo" );
			return false;
		}
		if ( Other.IsA('Sludge') )
		{
			ReplaceWith( Other, "Botpack.BioAmmo" );
			return false;
		}
		bSuperRelevant = 0;
		return true;
	}

	if ( Other.IsA('Pickup') )
	{
		Pickup(Other).bAutoActivate = true;
		if ( Other.IsA('TournamentPickup') )
			return true;
	}
	if ( Other.IsA('TournamentHealth') )
		return true;

	if ( Other.IsA('JumpBoots') )
	{
		ReplaceWith( Other, "Botpack.UT_JumpBoots" );
		return false;
	}
	if ( Other.IsA('Amplifier') )
	{
		ReplaceWith( Other, "Botpack.UDamage" );
		return false;
	}
	if ( Other.IsA('WeaponPowerUp') )
		return false; 

	if ( Other.IsA('KevlarSuit') )
	{
		ReplaceWith( Other, "Botpack.ThighPads");
		return false;
	}
	if ( Other.IsA('SuperHealth') )
	{
		ReplaceWith( Other, "Botpack.HealthPack" );
		return false;
	}
	if ( Other.IsA('Armor') )
	{
		ReplaceWith( Other, "Botpack.Armor2" );
		return false;
	}
	if ( Other.IsA('Bandages') )
	{
		ReplaceWith( Other, "Botpack.HealthVial" );
		return false;
	}
	if ( Other.IsA('Health') && !Other.IsA('HealthPack') && !Other.IsA('HealthVial')
		 && !Other.IsA('MedBox') && !Other.IsA('NaliFruit') )
	{
		ReplaceWith( Other, "Botpack.MedBox" );
		return false;
	}
	if ( Other.IsA('ShieldBelt') )
	{
		ReplaceWith( Other, "Botpack.UT_ShieldBelt" );
		return false;
	}
	if ( Other.IsA('Invisibility') )
	{
		ReplaceWith( Other, "Botpack.UT_Invisibility" );
		return false;
	}

	bSuperRelevant = 0;
	return true;
}

defaultproperties
{
}


